//+------------------------------------------------------------------+
//|                                                 KG MA V 1.3b.mq4 |
//|                      Copyright  2008, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+

#property copyright "Copyright  2008, MetaQuotes Software Corp."
#property link      "http://www.forexindo.com/forum/showthread.php?t=95&page=9"

#property indicator_chart_window
#property indicator_buffers 8

extern int Corner=1;
extern int MA_Mode=MODE_SMA;
extern color MA_Month_Color=Aqua;
extern color MA_Week_Color=Magenta;
extern color MA_Day_Color=Lime;
extern color MA_8H_Color=Yellow;
extern color MA_4H_Color=MediumBlue;
extern color MA_1H_Color=Red;
extern color MA_30M_Color=DarkViolet;
extern color MA_15M_Color=White;
//---- buffers
double MAMonth[];
double MAWeek[];
double MA24H[];
double MA8H[];
double MA4H[];
double MA1H[];
double MA30M[];
double MA15M[];
int    PerMonth;
int    PerWeek;
int    Per24H;
int    Per8H;
int    Per4H;
int    Per1H;
int    Per30M;
int    Per15M;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE,0,2,MA_Month_Color);
   SetIndexBuffer(0,MAMonth);
   SetIndexLabel(0,"MA Month");
   SetIndexStyle(1,DRAW_LINE,0,2,MA_Week_Color);
   SetIndexBuffer(1,MAWeek);
   SetIndexLabel(1,"MA Week");
   SetIndexStyle(2,DRAW_LINE,0,2,MA_Day_Color);
   SetIndexBuffer(2,MA24H);
   SetIndexLabel(2,"MA Day");
   SetIndexStyle(3,DRAW_LINE,0,2,MA_8H_Color);
   SetIndexBuffer(3,MA8H);
   SetIndexLabel(3,"MA 8H");
   SetIndexStyle(4,DRAW_LINE,0,2,MA_4H_Color);
   SetIndexBuffer(4,MA4H);
   SetIndexLabel(4,"MA 4H");
   SetIndexStyle(5,DRAW_LINE,0,2,MA_1H_Color);
   SetIndexBuffer(5,MA1H);
   SetIndexLabel(5,"MA 1H");
   SetIndexStyle(6,DRAW_LINE,0,2,MA_30M_Color);
   SetIndexBuffer(6,MA30M);
   SetIndexLabel(6,"MA 30M");
   SetIndexStyle(7,DRAW_LINE,0,2,MA_15M_Color);
   SetIndexBuffer(7,MA15M);
   SetIndexLabel(7,"MA 15M");
   
   string label1 = "KG MA Month";
   ObjectDelete(label1);
   ObjectCreate( label1, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(label1,"Monthly MA",8, "Arial Bold", MA_Month_Color);
   ObjectSet( label1, OBJPROP_CORNER, Corner );
   ObjectSet( label1, OBJPROP_XDISTANCE, 3 );
   ObjectSet( label1, OBJPROP_YDISTANCE, 10 );
   
   string label2 = "KG MA Week";
   ObjectDelete(label2);
   ObjectCreate( label2, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(label2,"Weekly MA",8, "Arial Bold", MA_Week_Color);
   ObjectSet( label2, OBJPROP_CORNER, Corner );
   ObjectSet( label2, OBJPROP_XDISTANCE, 3 );
   ObjectSet( label2, OBJPROP_YDISTANCE, 20 );
   
   string label3 = "KG MA Day";
   ObjectDelete(label3);
   ObjectCreate( label3, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(label3,"Daily MA",8, "Arial Bold", MA_Day_Color);
   ObjectSet( label3, OBJPROP_CORNER, Corner );
   ObjectSet( label3, OBJPROP_XDISTANCE, 3 );
   ObjectSet( label3, OBJPROP_YDISTANCE, 30 );
   
   string label4 = "KG MA 8H";
   ObjectDelete(label4);
   ObjectCreate( label4, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(label4,"8H MA",8, "Arial Bold", MA_8H_Color);
   ObjectSet( label4, OBJPROP_CORNER, Corner );
   ObjectSet( label4, OBJPROP_XDISTANCE, 3 );
   ObjectSet( label4, OBJPROP_YDISTANCE, 40 );
   
   string label5 = "KG MA 4H";
   ObjectDelete(label5);
   ObjectCreate( label5, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(label5,"4H MA",8, "Arial Bold", MA_4H_Color);
   ObjectSet( label5, OBJPROP_CORNER, Corner );
   ObjectSet( label5, OBJPROP_XDISTANCE, 3 );
   ObjectSet( label5, OBJPROP_YDISTANCE, 50 );
   
   string label6 = "KG MA 1H";
   ObjectDelete(label6);
   ObjectCreate( label6, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(label6,"1H MA",8, "Arial Bold", MA_1H_Color);
   ObjectSet( label6, OBJPROP_CORNER, Corner );
   ObjectSet( label6, OBJPROP_XDISTANCE, 3 );
   ObjectSet( label6, OBJPROP_YDISTANCE, 60 );

   string label7 = "KG MA 30M";
   ObjectDelete(label7);
   ObjectCreate( label7, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(label7,"30M MA",8, "Arial Bold", MA_30M_Color);
   ObjectSet( label7, OBJPROP_CORNER, Corner );
   ObjectSet( label7, OBJPROP_XDISTANCE, 3 );
   ObjectSet( label7, OBJPROP_YDISTANCE, 70 );
   
   string label8 = "KG MA 15M";
   ObjectDelete(label8);
   ObjectCreate( label8, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(label8,"15M MA",8, "Arial Bold", MA_15M_Color);
   ObjectSet( label8, OBJPROP_CORNER, Corner );
   ObjectSet( label8, OBJPROP_XDISTANCE, 3 );
   ObjectSet( label8, OBJPROP_YDISTANCE, 80 );

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   for(int i = ObjectsTotal() - 1; i >= 0; i--)
     {
       string label = ObjectName(i);
       if(StringSubstr(label, 0, 5) != "KG MA")
           continue;
       ObjectDelete(label);   
     }   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
//----
   int ActivePer=Period();
   PerMonth=28800/ActivePer;
   PerWeek=7200/ActivePer;
   Per24H=1440/ActivePer;
   Per8H=480/ActivePer;
   Per4H=240/ActivePer;
   Per1H=60/ActivePer;
   Per30M=30/ActivePer;
   Per15M=15/ActivePer;
   int limit=Bars-counted_bars;
   if(counted_bars>0) limit++;
   for(int i=0; i<limit; i++)
   { 
      MAMonth[i]=iMA(NULL,0,PerMonth,0,MA_Mode,PRICE_WEIGHTED,i);
      MAWeek[i]=iMA(NULL,0,PerWeek,0,MA_Mode,PRICE_WEIGHTED,i);
      MA24H[i]=iMA(NULL,0,Per24H,0,MA_Mode,PRICE_WEIGHTED,i);
      MA8H[i]=iMA(NULL,0,Per8H,0,MA_Mode,PRICE_WEIGHTED,i);
      MA4H[i]=iMA(NULL,0,Per4H,0,MA_Mode,PRICE_WEIGHTED,i);
      MA1H[i]=iMA(NULL,0,Per1H,0,MA_Mode,PRICE_WEIGHTED,i);
      MA30M[i]=iMA(NULL,0,Per30M,0,MA_Mode,PRICE_WEIGHTED,i);
      MA15M[i]=iMA(NULL,0,Per15M,0,MA_Mode,PRICE_WEIGHTED,i);
   }
   
   string Sign;
   double MAOpen=iMA(NULL,0,PerMonth,0,MA_Mode,PRICE_WEIGHTED,1);
   double MAClose=iMA(NULL,0,PerMonth,0,MA_Mode,PRICE_WEIGHTED,0);
   color Col;
   
   if (MAOpen==MAClose) { Sign=""; Col=Yellow; } //Sideway
   else 
      if (MAOpen < MAClose) { Sign=""; Col=Lime; } //Trend Up
      else { Sign=""; Col=Red; } //Trend Down
   string sign1 = "KG MA Month Sign";
   ObjectDelete(sign1);
   ObjectCreate(sign1, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(sign1, Sign ,10, "Wingdings", Col);
   ObjectSet(sign1, OBJPROP_CORNER, Corner );
   ObjectSet(sign1, OBJPROP_XDISTANCE, 63 );
   ObjectSet(sign1, OBJPROP_YDISTANCE, 10 );
   
   MAOpen=iMA(NULL,0,PerWeek,0,MA_Mode,PRICE_WEIGHTED,1);
   MAClose=iMA(NULL,0,PerWeek,0,MA_Mode,PRICE_WEIGHTED,0);
   if (MAOpen==MAClose) { Sign=""; Col=Yellow; } //Sideway
   else 
      if (MAOpen < MAClose) { Sign=""; Col=Lime; } //Trend Up
      else { Sign=""; Col=Red; } //Trend Down
   string sign2 = "KG MA Week Sign";
   ObjectDelete(sign2);
   ObjectCreate(sign2, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(sign2, Sign ,10, "Wingdings", Col);
   ObjectSet(sign2, OBJPROP_CORNER, Corner );
   ObjectSet(sign2, OBJPROP_XDISTANCE, 63 );
   ObjectSet(sign2, OBJPROP_YDISTANCE, 20 );

   MAOpen=iMA(NULL,0,Per24H,0,MA_Mode,PRICE_WEIGHTED,1);
   MAClose=iMA(NULL,0,Per24H,0,MA_Mode,PRICE_WEIGHTED,0);
   if (MAOpen==MAClose) { Sign=""; Col=Yellow; } //Sideway
   else 
      if (MAOpen < MAClose) { Sign=""; Col=Lime; } //Trend Up
      else { Sign=""; Col=Red; } //Trend Down
   string sign3 = "KG MA Day Sign";
   ObjectDelete(sign3);
   ObjectCreate(sign3, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(sign3, Sign ,10, "Wingdings", Col);
   ObjectSet(sign3, OBJPROP_CORNER, Corner );
   ObjectSet(sign3, OBJPROP_XDISTANCE, 63 );
   ObjectSet(sign3, OBJPROP_YDISTANCE, 30 );

   MAOpen=iMA(NULL,0,Per8H,0,MA_Mode,PRICE_WEIGHTED,1);
   MAClose=iMA(NULL,0,Per8H,0,MA_Mode,PRICE_WEIGHTED,0);
   if (MAOpen==MAClose) { Sign=""; Col=Yellow; } //Sideway
   else 
      if (MAOpen < MAClose) { Sign=""; Col=Lime; } //Trend Up
      else { Sign=""; Col=Red; } //Trend Down
   string sign4 = "KG MA 8H Sign";
   ObjectDelete(sign4);
   ObjectCreate(sign4, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(sign4, Sign ,10, "Wingdings", Col);
   ObjectSet(sign4, OBJPROP_CORNER, Corner );
   ObjectSet(sign4, OBJPROP_XDISTANCE, 63 );
   ObjectSet(sign4, OBJPROP_YDISTANCE, 40 );
   
   MAOpen=iMA(NULL,0,Per4H,0,MA_Mode,PRICE_WEIGHTED,1);
   MAClose=iMA(NULL,0,Per4H,0,MA_Mode,PRICE_WEIGHTED,0);
   if (MAOpen==MAClose) { Sign=""; Col=Yellow; } //Sideway
   else 
      if (MAOpen < MAClose) { Sign=""; Col=Lime; } //Trend Up
      else { Sign=""; Col=Red; } //Trend Down
   string sign5 = "KG MA 4H Sign";
   ObjectDelete(sign5);
   ObjectCreate(sign5, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(sign5, Sign ,10, "Wingdings", Col);
   ObjectSet(sign5, OBJPROP_CORNER, Corner );
   ObjectSet(sign5, OBJPROP_XDISTANCE, 63 );
   ObjectSet(sign5, OBJPROP_YDISTANCE, 50 );

   MAOpen=iMA(NULL,0,Per1H,0,MA_Mode,PRICE_WEIGHTED,1);
   MAClose=iMA(NULL,0,Per1H,0,MA_Mode,PRICE_WEIGHTED,0);
   if (MAOpen==MAClose) { Sign=""; Col=Yellow; } //Sideway
   else 
      if (MAOpen < MAClose) { Sign=""; Col=Lime; } //Trend Up
      else { Sign=""; Col=Red; } //Trend Down
   string sign6 = "KG MA 1H Sign";
   ObjectDelete(sign6);
   ObjectCreate(sign6, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(sign6, Sign ,10, "Wingdings", Col);
   ObjectSet(sign6, OBJPROP_CORNER, Corner );
   ObjectSet(sign6, OBJPROP_XDISTANCE, 63 );
   ObjectSet(sign6, OBJPROP_YDISTANCE, 60 );

   MAOpen=iMA(NULL,0,Per30M,0,MA_Mode,PRICE_WEIGHTED,1);
   MAClose=iMA(NULL,0,Per30M,0,MA_Mode,PRICE_WEIGHTED,0);
   if (MAOpen==MAClose) { Sign=""; Col=Yellow; } //Sideway
   else 
      if (MAOpen < MAClose) { Sign=""; Col=Lime; } //Trend Up
      else { Sign=""; Col=Red; } //Trend Down
   string sign7 = "KG MA 30M Sign";
   ObjectDelete(sign7);
   ObjectCreate(sign7, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(sign7, Sign ,10, "Wingdings", Col);
   ObjectSet(sign7, OBJPROP_CORNER, Corner );
   ObjectSet(sign7, OBJPROP_XDISTANCE, 63 );
   ObjectSet(sign7, OBJPROP_YDISTANCE, 70 );
   
   MAOpen=iMA(NULL,0,Per15M,0,MA_Mode,PRICE_WEIGHTED,1);
   MAClose=iMA(NULL,0,Per15M,0,MA_Mode,PRICE_WEIGHTED,0);
   if (MAOpen==MAClose) { Sign=""; Col=Yellow; } //Sideway
   else 
      if (MAOpen < MAClose) { Sign=""; Col=Lime; } //Trend Up
      else { Sign=""; Col=Red; } //Trend Down
   string sign8 = "KG MA 15M Sign";
   ObjectDelete(sign8);
   ObjectCreate(sign8, OBJ_LABEL, 0, 0, 0 );
   ObjectSetText(sign8, Sign ,10, "Wingdings", Col);
   ObjectSet(sign8, OBJPROP_CORNER, Corner );
   ObjectSet(sign8, OBJPROP_XDISTANCE, 63 );
   ObjectSet(sign8, OBJPROP_YDISTANCE, 80 );
   
//----
   return(0);
  }
//+------------------------------------------------------------------+